/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.explorer.ui.filter;

import com.aptana.core.util.URLEncoder;
import com.aptana.explorer.ui.filter.AbstractResourceBasedViewerFilter;
import com.aptana.index.core.Index;
import com.aptana.index.core.IndexManager;
import com.aptana.index.core.IndexPlugin;
import com.aptana.index.core.QueryResult;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class PathFilter
extends AbstractResourceBasedViewerFilter {
    private static Object[] EMPTY = new Object[0];
    private Map<Object, Object[]> cache = new HashMap<Object, Object[]>();
    private Map<Object, Boolean> foundAnyCache = new HashMap<Object, Boolean>();
    private Map<Object, Boolean> leafCache = new HashMap<Object, Boolean>();
    private List<QueryResult> queryResults;
    private IResource filterResource;
    protected Pattern regexp;
    private String fFilterResourceURI;
    protected String patternString;

    protected boolean isElementVisible(Viewer viewer, Object element) {
        return this.isParentMatch(viewer, element) || this.isLeafMatch(viewer, element);
    }

    private boolean isAnyVisible(Viewer viewer, Object parent, Object[] elements) {
        Object[] filtered = this.cache.get(parent);
        if (filtered != null) {
            return filtered.length > 0;
        }
        Boolean foundAny = this.foundAnyCache.get(parent);
        if (foundAny == null) {
            foundAny = this.computeAnyVisible(viewer, elements) ? Boolean.TRUE : Boolean.FALSE;
            this.foundAnyCache.put(parent, foundAny);
        }
        return foundAny;
    }

    private boolean isParentMatch(Viewer viewer, Object element) {
        IResource resource = this.getResourceFromObject(element);
        if (resource == null) {
            return false;
        }
        if (this.wordMatches(resource.getName())) {
            return true;
        }
        Object[] children = ((ITreeContentProvider)((AbstractTreeViewer)viewer).getContentProvider()).getChildren(element);
        if (children != null && children.length > 0) {
            return this.isAnyVisible(viewer, element, children);
        }
        return false;
    }

    private IResource getResourceFromObject(Object element) {
        Object resource = element instanceof IResource ? (IResource)element : (element instanceof IAdaptable ? (IResource)((IAdaptable)element).getAdapter(IResource.class) : null);
        return resource;
    }

    private boolean computeAnyVisible(Viewer viewer, Object[] elements) {
        boolean elementFound = false;
        int i = 0;
        while (i < elements.length && !elementFound) {
            Object element = elements[i];
            elementFound = this.isElementVisible(viewer, element);
            ++i;
        }
        return elementFound;
    }

    public final boolean select(Viewer viewer, Object parentElement, Object element) {
        return this.isElementVisible(viewer, element);
    }

    private boolean isLeafMatch(Viewer viewer, Object element) {
        Boolean result = this.leafCache.get(element);
        if (result == null) {
            result = this.doIsLeafMatch(viewer, element);
            this.leafCache.put(element, result);
        }
        return result;
    }

    protected boolean doIsLeafMatch(Viewer viewer, Object element) {
        IResource resource = this.getResourceFromObject(element);
        if (resource == null) {
            return false;
        }
        if (resource.equals((Object)this.filterResource)) {
            return true;
        }
        IPath path = resource.getProjectRelativePath();
        String rawPath = path.toPortableString();
        if (this.wordMatches(rawPath)) {
            return true;
        }
        return this.isRequired(resource);
    }

    private boolean isRequired(IResource resource) {
        if (this.queryResults == null) {
            Index index = this.getIndexManager().getIndex(resource.getProject().getLocationURI());
            this.queryResults = index.query(this.indexCategories(), null, 0);
        }
        if (this.queryResults != null) {
            String resourceURI = null;
            String filterResourceLocation = this.filterResource.getLocation().toPortableString();
            String resourceLocation = resource.getLocation().toPortableString();
            for (QueryResult result : this.queryResults) {
                String includedFile = result.getWord();
                if (includedFile.endsWith(URLEncoder.encode((String)filterResourceLocation, null, null))) {
                    for (String document : result.getDocuments()) {
                        if (resourceURI == null) {
                            resourceURI = resource.getLocationURI().toString();
                        }
                        if (!document.equals(resourceURI)) continue;
                        return true;
                    }
                    continue;
                }
                if (!includedFile.endsWith(URLEncoder.encode((String)resourceLocation, null, null))) continue;
                for (String document : result.getDocuments()) {
                    if (!document.equals(this.getFilterResourceURI())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    protected IndexManager getIndexManager() {
        return IndexPlugin.getDefault().getIndexManager();
    }

    protected String[] indexCategories() {
        return new String[]{"html.resource.css", "html.resource.js"};
    }

    private String getFilterResourceURI() {
        if (this.fFilterResourceURI == null) {
            this.fFilterResourceURI = this.filterResource.getLocationURI().toString();
        }
        return this.fFilterResourceURI;
    }

    private boolean wordMatches(String text) {
        if (text == null) {
            return false;
        }
        return this.match(text);
    }

    protected boolean match(String string) {
        if (this.regexp == null) {
            return true;
        }
        return this.regexp.matcher(string).find();
    }

    protected void setPattern(String patternString) {
        this.patternString = patternString;
        this.regexp = patternString == null || patternString.equals("") ? null : Pattern.compile(MessageFormat.format("\\b({0})\\b", patternString));
    }

    public void setResourceToFilterOn(IResource resource) {
        this.clearCaches();
        if (this.queryResults != null) {
            this.queryResults = null;
        }
        this.fFilterResourceURI = null;
        if (resource == null) {
            this.filterResource = null;
            this.setPattern(null);
            return;
        }
        this.filterResource = resource;
        this.setPattern(this.createPatternFromResource(resource));
    }

    protected String createPatternFromResource(IResource resource) {
        return resource.getName();
    }

    public final Object[] filter(Viewer viewer, Object parent, Object[] elements) {
        if (this.regexp == null) {
            return elements;
        }
        Object[] filtered = this.cache.get(parent);
        if (filtered == null) {
            Boolean foundAny = this.foundAnyCache.get(parent);
            filtered = foundAny != null && foundAny == false ? EMPTY : super.filter(viewer, parent, elements);
            this.cache.put(parent, filtered);
        } else {
            ArrayList<Object> copyOfCache = new ArrayList<Object>();
            Object[] objectArray = filtered;
            int n = filtered.length;
            int n2 = 0;
            while (n2 < n) {
                Object cached = objectArray[n2];
                Object[] objectArray2 = elements;
                int n3 = elements.length;
                int n4 = 0;
                while (n4 < n3) {
                    Object element = objectArray2[n4];
                    if (cached.equals(element)) {
                        copyOfCache.add(element);
                        break;
                    }
                    ++n4;
                }
                if (copyOfCache.size() == filtered.length) break;
                ++n2;
            }
            filtered = copyOfCache.toArray();
        }
        return filtered;
    }

    private void clearCaches() {
        this.cache.clear();
        this.foundAnyCache.clear();
        this.leafCache.clear();
    }

    public String getPattern() {
        return this.patternString;
    }
}

